'Project: Four-Channel UHF Remote Switch Receiver
'Bascom-Avr IDE [2.0.7.5]
'Flash used 1024 Bytes
'Author: Mahmood Alimohammadi
'Date: June 1 , 2016
'*******************************************************************************
$regfile = "m8adef.dat"
$crystal = 1000000
Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portc.0 , Db5 = Portc.1 , Db6 = Portc.2 , Db7 = Portc.3 , Rs = Portc.4 , E = Portc.5

Config Portb = Output
Config Portd = Input

Portd.1 = 1
Portd.2 = 1
Portd.3 = 1

A Alias Portb.0
B Alias Portb.1
C Alias Portb.2
D Alias Portb.3

M Alias Pind.1
L Alias Pind.2
T Alias Pind.3
Vt Alias Pind.0
'*******************************************************************************

Cursor Off
Cls
Upperline
Lcd "Four-Channel UHF"
Lowerline
Lcd "Remote Switch"
Wait 2

Cls
Lcd "Select One Mode:"
Lowerline
Lcd "Mom/Latch/Toggle"
Wait 2
'*******************************************************************************
'Main Program
Do
If M = 0 Then
Gosub Momentary
Gosub Channels
End If

If L = 0 Then
Gosub Latch
Gosub Channels
If Vt = 1 Then
Portb = 0
End If
End If

If T = 0 Then
Gosub Toggles
Gosub Channels
End If

Loop

'*******************************************************************************

Momentary:

If Pind.4 = 1 Then
Set A
Else
Reset A
End If

If Pind.5 = 1 Then
Set B
Else
Reset B
End If

If Pind.6 = 1 Then
Set C
Else
Reset C
End If

If Pind.7 = 1 Then
Set D
Else
Reset D
End If

Cls
Lowerline
Lcd "Momentary Mode"

Return
'*******************************************************************************

Latch:

If Pind.4 = 1 Then
Set A

Elseif Pind.5 = 1 Then
Set B

Elseif Pind.6 = 1 Then
Set C

Elseif Pind.7 = 1 Then
Set D
End If


Cls
Lowerline
Lcd "Latch Mode"

Return
'*******************************************************************************

Toggles:

If Pind.4 = 1 Then
Toggle A

Elseif Pind.5 = 1 Then
Toggle B

Elseif Pind.6 = 1 Then
Toggle C

Elseif Pind.7 = 1 Then
Toggle D
End If
Waitms 200
Cls
Lowerline
Lcd "Toggle Mode"

Return

'*******************************************************************************
Channels:

Upperline
Lcd "A=" ; A ; " " ; "B=" ; B ; "  " ; "C=" ; C ; " " ; "D=" ; D
Waitms 200
Return


'End of Program

'*******************************************************************************